<?php
session_start();
$user = 'matin';
$pass = 'M@tin2025';

if (!isset($_SERVER['PHP_AUTH_USER']) || !isset($_SERVER['PHP_AUTH_PW']) ||
    $_SERVER['PHP_AUTH_USER'] !== $user || $_SERVER['PHP_AUTH_PW'] !== $pass) {
    header('WWW-Authenticate: Basic realm="Restricted Area"');
    header('HTTP/1.0 401 Unauthorized');
    echo "دسترسی محدود شده است.";
    exit;
}

// ---------- مسیرهای پایه ----------
$publicRoot = realpath(__DIR__ . '/..'); // مسیر public_html
$baseDirs = [
    '3DSKY'   => realpath($publicRoot . '/3DSKY'),
    'Texture' => realpath($publicRoot . '/Texture')
];
$baseDomain = 'https://dl.bimlearn.org';

// ---------- تابع ساخت URL دانلود مستقیم ----------
function fileUrlFromPath(string $filePath, string $publicRoot, string $baseDomain): string {
    $filePath = str_replace('\\','/',$filePath);
    $publicRoot = str_replace('\\','/',$publicRoot);
    $rel = str_replace($publicRoot, '', $filePath);
    $rel = ltrim($rel, '/');
    $parts = array_map('rawurlencode', explode('/', $rel));
    return rtrim($baseDomain, '/') . '/' . implode('/', $parts);
}

// ---------- پارامترها ----------
$query = strtolower($_GET['q'] ?? '');
$currentPath = realpath($_GET['path'] ?? '');

// بررسی اینکه مسیر داخل یکی از baseDirs باشد
$allowed = false;
foreach ($baseDirs as $dir) {
    if ($dir && strpos($currentPath, $dir) === 0) {
        $allowed = true;
        break;
    }
}
if (!$allowed) die("دسترسی غیرمجاز.");

$results = scandir($currentPath);
$i = 1;

echo '<ul class="space-y-2">';

foreach ($results as $item) {
    if ($item === '.' || $item === '..') continue;
    if (stripos($item, $query) !== false) {
        $itemPath = $currentPath . '/' . $item;
        if (is_file($itemPath)) {
            $fileId = "search_" . md5($itemPath);
            $url = fileUrlFromPath($itemPath, $publicRoot, $baseDomain);
            $size = number_format(filesize($itemPath) / (1024 * 1024), 2) . " MB";
            $ext = strtolower(pathinfo($item, PATHINFO_EXTENSION));

            echo "<li class='bg-white px-4 py-2 rounded shadow flex justify-between items-center'>";
            echo "<span id='$fileId'>📄 " . htmlspecialchars($item) . " <span class='text-gray-500 text-xs'>($size)</span></span>";
            echo "<div class='space-x-2'>";

            if (in_array($ext, ['zip', 'rar'])) {
                echo "<a href='$url' target='_blank' class='bg-blue-500 text-white px-2 py-1 rounded text-xs'>دانلود</a>";
            }
            if ($ext === 'zip') {
                echo "<button onclick='extractZip(\"" . addslashes($itemPath) . "\")' class='bg-yellow-500 text-white px-2 py-1 rounded text-xs'>📦 استخراج</button>";
            }
            echo "<button onclick='renameFile(\"" . addslashes($itemPath) . "\", \"$fileId\")' class='bg-orange-500 text-white px-2 py-1 rounded text-xs'>✏️ تغییر نام</button>";

            echo "</div></li>";
            $i++;
        }
    }
}
echo '</ul>';
