<?php
session_start();
$user = 'matin'; 
$pass = 'M@tin2025';

if (!isset($_SERVER['PHP_AUTH_USER'], $_SERVER['PHP_AUTH_PW']) ||
    $_SERVER['PHP_AUTH_USER'] !== $user || $_SERVER['PHP_AUTH_PW'] !== $pass) {
    header('WWW-Authenticate: Basic realm="Restricted"');
    header('HTTP/1.0 401 Unauthorized');
    exit("دسترسی محدود.");
}

// ---------- مسیرهای پایه ----------
$publicRoot = realpath(__DIR__ . '/..');
$baseDirs = [
    '3DSKY'   => realpath($publicRoot . '/3DSKY'),
    'Texture' => realpath($publicRoot . '/Texture')
];

// ---------- بررسی مسیر مقصد ----------
$targetDir = isset($_POST['currentPath']) ? realpath($_POST['currentPath']) : null;

$allowed = false;
if ($targetDir) {
    foreach ($baseDirs as $dir) {
        if ($dir && strpos($targetDir, $dir) === 0) {
            $allowed = true;
            break;
        }
    }
}
if (!$allowed) {
    die("❌ مسیر نامعتبر.");
}

// ---------- آپلود Resume (Chunked) ----------
if (isset($_POST['chunkIndex'])) {
    $chunkIndex = intval($_POST['chunkIndex']);
    $totalChunks = intval($_POST['totalChunks']);
    $filename = basename($_POST['filename']);
    $ext = strtolower(pathinfo($filename, PATHINFO_EXTENSION));

    if (!in_array($ext, ['zip', 'rar'])) {
        die("❌ فقط zip و rar مجاز هستند.");
    }

    $tmpFile = $targetDir . DIRECTORY_SEPARATOR . $filename . ".part";
    $out = fopen($tmpFile, $chunkIndex === 0 ? "wb" : "ab");
    if (!$out) die("❌ خطا در ایجاد فایل موقت.");

    $in = fopen($_FILES['upload']['tmp_name'], "rb");
    if (!$in) die("❌ خطا در خواندن chunk.");

    while ($buff = fread($in, 1048576)) {
        fwrite($out, $buff);
    }
    fclose($in); fclose($out);

    // اگر همه chunk ها رسید، تغییر نام به فایل نهایی
    if ($chunkIndex + 1 === $totalChunks) {
        $finalFile = $targetDir . DIRECTORY_SEPARATOR . $filename;
        if (file_exists($finalFile)) unlink($finalFile);
        rename($tmpFile, $finalFile);
        echo "✅ آپلود کامل شد.";
    } else {
        echo "✅ Chunk $chunkIndex از $totalChunks ذخیره شد.";
    }
    exit;
}

// ---------- آپلود معمولی ----------
if (!isset($_FILES['upload']) || $_FILES['upload']['error'] !== UPLOAD_ERR_OK) {
    die("❌ خطا در آپلود فایل.");
}

$ext = strtolower(pathinfo($_FILES['upload']['name'], PATHINFO_EXTENSION));
if (!in_array($ext, ['zip', 'rar'])) {
    die("❌ فقط فایل‌های zip و rar مجاز هستند.");
}

$filename = basename($_FILES['upload']['name']);
$destination = $targetDir . DIRECTORY_SEPARATOR . $filename;

if (move_uploaded_file($_FILES['upload']['tmp_name'], $destination)) {
    echo "✅ فایل با موفقیت آپلود شد.";
} else {
    echo "❌ خطا در انتقال فایل.";
}
